<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    class Mappa {
        private $db;
        private $id;
        private $nome;
        private $spazioOccupato;
        private $indirizzo;
        private $tipo;
        private $html;
        private $javascript;
        private $latitudine;
        private $longitudine;
       
        public function __construct($db, $id, $nome="", $spazioOccupato = "", $indirizzo="", $tipo="", $html="", $javascript="", $latitudine="", $longitudine="") {
            $this->db = $db;
            $this->id = $id;
            $this->nome = $nome;
            $this->spazioOccupato = $spazioOccupato;
            $this->indirizzo = $indirizzo;
            $this->tipo = $tipo;
            $this->html = $html;
            $this->javascript = $javascript;
            $this->latitudine = $latitudine;
            $this->longitudine = $longitudine;
        }

        
        function crea() {
            $dataOggi = date("Y-m-d H:m:s");
            $query ="INSERT INTO geec_mappe VALUES(NULL,'$this->nome','$this->spazioOccupato','$this->indirizzo','$this->tipo','$this->html','$this->javascript','$this->latitudine','$this->longitudine')";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        function modifica() {
            $query = "UPDATE geec_mappe SET nome='$this->nome', spazioOccupato='$this->spazioOccupato', indirizzo='$this->indirizzo', tipo='$this->tipo', html='$this->html', javascript='$this->javascript', latitudine='$this->latitudine', longitudine='$this->longitudine' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $this->db->eseguiQueryCancellazione("geec_mappe",$this->id);
            
            // elimina le occorrenze in cui la form è presente, l'id di questo componente è 41
            eliminaOccorrenzeComponente($this->db,$this->id,41);
        }
        
        function duplica($prefisso = "Copia di ") {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_mappe WHERE id=$this->id");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_mappe SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            
            $this->db->eseguiQueryScrittura("UPDATE geec_mappe SET nome = CONCAT('$prefisso', ' ', nome) WHERE id=$idContenutoDuplicato");
            return $idContenutoDuplicato;
        }
        
        function caricaDatiDalDatabase() {
            $datiMappa   = $this->db->leggiSingolaRiga("geec_mappe",$this->id);
            $this->nome           = $datiMappa["nome"];
            $this->spazioOccupato = $datiMappa["spazioOccupato"];
            $this->indirizzo      = $datiMappa["indirizzo"];
            $this->tipo           = $datiMappa["tipo"];
            $this->html           = $datiMappa["html"];
            $this->javascript     = $datiMappa["javascript"];
            $this->latitudine     = $datiMappa["latitudine"];
            $this->longitudine    = $datiMappa["longitudine"];
        }
        
        // getter & setter
        public function getDb() {
            return $this->db;
        }

        public function getId() {
            return $this->id;
        }

        public function getNome() {
            return $this->nome;
        }

        public function getSpazioOccupato() {
            return $this->spazioOccupato;
        }

        public function getIndirizzo() {
            return $this->indirizzo;
        }

        public function getTipo() {
            return $this->tipo;
        }

        public function getHtml() {
            return $this->html;
        }

        public function getJavascript() {
            return $this->javascript;
        }

        public function getLatitudine() {
            return $this->latitudine;
        }

        public function getLongitudine() {
            return $this->longitudine;
        }

        public function setDb($db) {
            $this->db = $db;
        }

        public function setId($id) {
            $this->id = $id;
        }

        public function setNome($nome) {
            $this->nome = $nome;
        }

        public function setSpazioOccupato($spazioOccupato) {
            $this->spazioOccupato = $spazioOccupato;
        }

        public function setIndirizzo($indirizzo) {
            $this->indirizzo = $indirizzo;
        }

        public function setTipo($tipo) {
            $this->tipo = $tipo;
        }

        public function setHtml($html) {
            $this->html = $html;
        }

        public function setJavascript($javascript) {
            $this->javascript = $javascript;
        }

        public function setLatitudine($latitudine) {
            $this->latitudine = $latitudine;
        }

        public function setLongitudine($longitudine) {
            $this->longitudine = $longitudine;
        }

    }